﻿//////////////////////////////////////////////
// Cursor.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class System ;
}

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkWinUi
{
	class Cursor
	{
		public :

			// Destructor
			virtual ~Cursor () ;

			// Getters
			nkMemory::StringView getName () const ;

			// Setters
			void setName (nkMemory::StringView value) ;

			// Load
			virtual bool load () = 0 ;
			virtual void unload () = 0 ;

			// Activation
			virtual void activate () = 0 ;
			virtual void deactivate () = 0 ;

		public :

			// Statics
			static nkMemory::UniquePtr<Cursor> create (System* system = nullptr) ;

		protected :

			// Attributes
			nkMemory::String _name ;
	} ;
}